/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;

public class Sphere
extends Primitive {
    public static final int BODY = 0;
    static final int MID_REZ_DIV = 16;
    float radius;
    int divisions;

    public Sphere(float f2) {
        this(f2, 1, 16);
    }

    public Sphere() {
        this(1.0f, 1, 16);
    }

    public Sphere(float f2, Appearance appearance) {
        this(f2, 1, 16, appearance);
    }

    public Sphere(float f2, int n2, Appearance appearance) {
        this(f2, n2, 16, appearance);
    }

    public Sphere(float f2, int n2, int n3) {
        this(f2, n2, n3, null);
    }

    public Shape3D getShape(int n2) {
        if (n2 != 0) {
            return null;
        }
        return (Shape3D)this.getChild(0);
    }

    public Shape3D getShape() {
        return (Shape3D)this.getChild(0);
    }

    public void setAppearance(Appearance appearance) {
        ((Shape3D)this.getChild(0)).setAppearance(appearance);
    }

    public Appearance getAppearance(int n2) {
        if (n2 != 0) {
            return null;
        }
        return this.getShape(n2).getAppearance();
    }

    public Sphere(float f2, int n2, int n3, Appearance appearance) {
        Shape3D shape3D;
        int n4;
        int n5;
        this.radius = f2;
        this.divisions = n3;
        this.flags = n2;
        boolean bl = (this.flags & 8) != 0;
        int n6 = (this.flags & 4) != 0 ? -1 : 1;
        if (n3 < 4) {
            n5 = 1;
            n4 = 4;
        } else {
            int n7 = n3 % 4;
            n4 = n7 == 0 ? n3 : n3 + (4 - n7);
            n5 = n4 / 4;
        }
        GeomBuffer geomBuffer = this.getCachedGeometry(1, f2, 0.0f, 0.0f, n3, 0, n2);
        if (geomBuffer != null) {
            shape3D = new Shape3D(geomBuffer.getComputedGeometry());
            this.numVerts += geomBuffer.getNumVerts();
            this.numTris += geomBuffer.getNumTris();
        } else {
            TexCoord2f[] texCoord2fArray;
            GeomBuffer geomBuffer2 = new GeomBuffer(8 * n5 * (n5 + 2));
            for (int i2 = 0; i2 < 4; ++i2) {
                this.buildQuadrant(geomBuffer2, (double)i2 * Math.PI / 2.0, (double)(i2 + 1) * Math.PI / 2.0, n6, n5, n4, true);
                this.buildQuadrant(geomBuffer2, (double)i2 * Math.PI / 2.0, (double)(i2 + 1) * Math.PI / 2.0, n6, n5, n4, false);
            }
            if (bl && (texCoord2fArray = geomBuffer2.getTexCoords()) != null) {
                for (int i3 = 0; i3 < texCoord2fArray.length; ++i3) {
                    texCoord2fArray[i3].y = 1.0f - texCoord2fArray[i3].y;
                }
            }
            shape3D = new Shape3D(geomBuffer2.getGeom(this.flags));
            this.numVerts = geomBuffer2.getNumVerts();
            this.numTris = geomBuffer2.getNumTris();
            if ((n2 & 0x10) == 0) {
                this.cacheGeometry(1, f2, 0.0f, 0.0f, n3, 0, n2, geomBuffer2);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3D.setCapability(14);
            shape3D.setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape3D.setCapability(12);
        }
        this.addChild(shape3D);
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Node cloneNode(boolean bl) {
        Sphere sphere = new Sphere(this.radius, this.flags, this.divisions, this.getAppearance());
        sphere.duplicateNode(this, bl);
        return sphere;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public float getRadius() {
        return this.radius;
    }

    public int getDivisions() {
        return this.divisions;
    }

    void buildQuadrant(GeomBuffer geomBuffer, double d2, double d3, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        double d4;
        double d5;
        double d6;
        if (bl) {
            d5 = d6 = Math.PI / (double)(2 * n3);
            d4 = 1.0;
            bl2 = n2 > 0;
        } else {
            d6 = -Math.PI / (double)(2 * n3);
            d5 = Math.PI + d6;
            d4 = -1.0;
            bl2 = n2 < 0;
        }
        for (int i2 = 1; i2 <= n3; ++i2) {
            TexCoord2f texCoord2f;
            Vector3f vector3f;
            Point3f point3f;
            int n5;
            double d7;
            double d8;
            int n6;
            double d9;
            double d10 = Math.cos(d5);
            double d11 = Math.sin(d5);
            double d12 = n2 > 0 ? 1.0 - d5 / Math.PI : d5 / Math.PI;
            int n7 = i2 << 1;
            double d13 = (d3 - d2) / (double)i2;
            geomBuffer.begin(32);
            if (bl2) {
                d9 = d2;
                for (n6 = 0; n6 < i2; ++n6) {
                    d8 = d11 * Math.cos(d9);
                    d7 = d11 * Math.sin(d9);
                    geomBuffer.normal3d(d8 * (double)n2, d10 * (double)n2, d7 * (double)n2);
                    geomBuffer.texCoord2d(0.75 - d9 / (Math.PI * 2), d12);
                    geomBuffer.vertex3d(d8 * (double)this.radius, d10 * (double)this.radius, d7 * (double)this.radius);
                    if (i2 > 1) {
                        n5 = geomBuffer.currVertCnt - n7;
                        point3f = geomBuffer.pts[n5];
                        vector3f = geomBuffer.normals[n5];
                        texCoord2f = geomBuffer.tcoords[n5];
                        geomBuffer.normal3d(vector3f.x, vector3f.y, vector3f.z);
                        geomBuffer.texCoord2d(texCoord2f.x, texCoord2f.y);
                        geomBuffer.vertex3d(point3f.x, point3f.y, point3f.z);
                    } else {
                        geomBuffer.normal3d(0.0, (double)n2 * d4, 0.0);
                        if (n2 > 0) {
                            geomBuffer.texCoord2d(0.75 - (d2 + d3) / (Math.PI * 4), 1.0 - (d5 - d6) / Math.PI);
                        } else {
                            geomBuffer.texCoord2d(0.75 - (d2 + d3) / (Math.PI * 4), (d5 - d6) / Math.PI);
                        }
                        geomBuffer.vertex3d(0.0, d4 * (double)this.radius, 0.0);
                    }
                    d9 += d13;
                }
                d9 = d3;
                d8 = d11 * Math.cos(d9);
                d7 = d11 * Math.sin(d9);
                geomBuffer.normal3d(d8 * (double)n2, d10 * (double)n2, d7 * (double)n2);
                geomBuffer.texCoord2d(0.75 - d9 / (Math.PI * 2), d12);
                geomBuffer.vertex3d(d8 * (double)this.radius, d10 * (double)this.radius, d7 * (double)this.radius);
            } else {
                d9 = d3;
                for (n6 = i2; n6 > 0; --n6) {
                    d8 = d11 * Math.cos(d9);
                    d7 = d11 * Math.sin(d9);
                    geomBuffer.normal3d(d8 * (double)n2, d10 * (double)n2, d7 * (double)n2);
                    geomBuffer.texCoord2d(0.75 - d9 / (Math.PI * 2), d12);
                    geomBuffer.vertex3d(d8 * (double)this.radius, d10 * (double)this.radius, d7 * (double)this.radius);
                    if (i2 > 1) {
                        n5 = geomBuffer.currVertCnt - n7;
                        point3f = geomBuffer.pts[n5];
                        vector3f = geomBuffer.normals[n5];
                        texCoord2f = geomBuffer.tcoords[n5];
                        geomBuffer.normal3d(vector3f.x, vector3f.y, vector3f.z);
                        geomBuffer.texCoord2d(texCoord2f.x, texCoord2f.y);
                        geomBuffer.vertex3d(point3f.x, point3f.y, point3f.z);
                    } else {
                        geomBuffer.normal3d(0.0, (double)n2 * d4, 0.0);
                        if (n2 > 0) {
                            geomBuffer.texCoord2d(0.75 - (d2 + d3) / (Math.PI * 4), 1.0 - (d5 - d6) / Math.PI);
                        } else {
                            geomBuffer.texCoord2d(0.75 - (d2 + d3) / (Math.PI * 4), (d5 - d6) / Math.PI);
                        }
                        geomBuffer.vertex3d(0.0, d4 * (double)this.radius, 0.0);
                    }
                    d9 -= d13;
                }
                d9 = d2;
                d8 = d11 * Math.cos(d9);
                d7 = d11 * Math.sin(d9);
                geomBuffer.normal3d(d8 * (double)n2, d10 * (double)n2, d7 * (double)n2);
                geomBuffer.texCoord2d(0.75 - d9 / (Math.PI * 2), d12);
                geomBuffer.vertex3d(d8 * (double)this.radius, d10 * (double)this.radius, d7 * (double)this.radius);
            }
            geomBuffer.end();
            if (i2 < n3) {
                d5 += d6;
                continue;
            }
            d5 = 1.5707963267948966;
        }
    }
}

